package com.androidbook.simplewebextension;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;

public class SimpleWebExtension extends Activity {
    private static final String DEBUG_TAG = "SimpleWebExtension";

    /** Metoda wywoływana podczas pierwszego tworzenia aktywności. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        final WebView wv = (WebView) findViewById(R.id.html_viewer);
        WebSettings settings = wv.getSettings();
        settings.setJavaScriptEnabled(true);
        WebChromeClient webChrome = new WebChromeClient() {
            @Override
            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                Log.v(DEBUG_TAG, consoleMessage.lineNumber() + ": " + consoleMessage.message());
                return true;
            }
        };

        // Trzeba wywołać tę metodę, by prawidłowo działała konsola i komunikaty.
        wv.setWebChromeClient(webChrome);
        wv.addJavascriptInterface(new JavaScriptExtensions(), "jse");
        
        // Wczytujemy naszą prostą stronę WWWW.
        wv.loadUrl("file:///android_asset/sample.html");
    }
    
    
    
    public void setHTMLText(View view) {
        WebView wv = (WebView) findViewById(R.id.html_viewer);
        // Wywołanie o tej postaci jest nieco podobne do, tak zwanych, "bookmarklets",
        // gdyż przeglądarka wywołuje określony kod JavaScript w kontekście aktualnie wyświetlonej strony.
        wv.loadUrl("javascript:doSetFormText('Wywołanie Java->JS');");
    }

    class JavaScriptExtensions {
        public static final int TOAST_LONG = Toast.LENGTH_LONG;
        public static final int TOAST_SHORT = Toast.LENGTH_SHORT;
        
        public void toast(String message, int length) {
            Toast.makeText(SimpleWebExtension.this, message, length).show();
        }
    }
    
    
}